!Object constantsFor: 'Geos Libraries'!

geosLIB49 'SYSTEM\netutils'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

addressControlSetMedium 27648!
addressControlGetAddresses 27649!
addressControlSetAddresses 27650!
addressControlSetAction 27651!
addressControlSetValidState 27652!
!

!Geos class methodsFor: 'library calls'!

NetGenerateRandom32
	"long pascal NetGenerateRandom32() in internal/netutils.h"
	^GEOS call: #[49 0 22 2]!

NetGenerateRandom8: limit
	"int pascal NetGenerateRandom8(int limit) in internal/netutils.h"
	^GEOS call: limit with: #[49 0 21 4 4]!

!

GenControl subclass: #SocketAddressControl
	instanceVariableNames: ''
	classVariableNames: ''!

!SocketAddressControl comment!
Library netutils, file sac.goh! !

!SocketAddressControl class methodsFor: 'library linkage'!

library
	^49!

entry
	^0!
!

!SocketAddressControl methodsFor: 'Geos instance variables'!

saciActionMsg
	"@instance word SACI_actionMsg"
	^self wordAt: 25!

saciActionMsg: value
	"@instance word SACI_actionMsg"
	^self wordAt: 25 put: value!

saciGeode
	"@instance word SACI_geode"
	^self wordAt: 27!

saciGeode: value
	"@instance word SACI_geode"
	^self wordAt: 27 put: value!

!

!SocketAddressControl methodsFor: 'Geos vardata'!

!

!SocketAddressControl methodsFor: 'Geos messages'!

addressControlSetMedium: mediumType
	"@message void MSG_SOCKET_ADDRESS_CONTROL_SET_MEDIUM(MediumType mediumType = cx:dx)"
	^self geosMessage: #[108 0 2 53 2 0] with: mediumType!

addressControlGetAddresses
	"@message word MSG_SOCKET_ADDRESS_CONTROL_GET_ADDRESSES()= ax"
	^self geosMessage: #[108 1 98 0 1]!

addressControlSetAddresses: addr
	"@message void MSG_SOCKET_ADDRESS_CONTROL_SET_ADDRESSES(optr addr = cx:dx)"
	^self geosMessage: #[108 2 2 53 2 0] with: addr!

addressControlSetAction: dest with: actionMsg
	"@message void MSG_SOCKET_ADDRESS_CONTROL_SET_ACTION(optr dest = cx:dx, word actionMsg = bp)"
	^self geosMessage: #[108 3 3 245 2 1 0] with: dest with: actionMsg!

addressControlSetValidState: valid
	"@message void MSG_SOCKET_ADDRESS_CONTROL_SET_VALID_STATE(Boolean valid = cx)"
	^self geosMessage: #[108 4 2 5 4 0] with: valid!

!

